# Stelle sicher dass du python auf der Maschine installiert hast!
# Du benoetigst einen Battlemetrics API Key die ID des Servers bei BM.
# Von deinem Discord musst die Kanal-ID, in welche der Bot posten soll.

# Du musst den Bot 1x starten, damit er die benoetigten Dateien anlegt.
# Danach kannst du die IDs und Keys in die config.ini eintragen und den Bot starten.

#--------------------------------------------------------
# Dieser Bot wurde von der Scumworld.de Community erstellt.
# Veraendern und Erweitern ist ausdruecklich erwuenscht,
# solange es mit der Scumworld.de Community geteilt wird!
# Jegliche Vermarktung oder Verbreitung ist untersagt!
#--------------------------------------------------------

# Version 0.8.9 vom 11.03.2023 // SCOMMY by FMJ (Alte Saecke)

# Version 0.8.10 vom 28.03.2025 Anpassung by Catweazle (Adventure-Island)
#   Anpassung:  Die Spieleranzahl wird nun als Nickname im Bot angezeigt   
#               Die Uhrzeit des Servers wird als Status angezeigt

# Bitte beachte dass sich der Bot in Entwicklung befindet und
# staendig Aenderungen erfaehrt und auch Fehler haben kann und hat!

# Support und weitere Informationen zum Bot findest du im Scumworld.de Forum.

import os
import subprocess
import sys
import configparser
import gettext
import importlib

def install_package(package):
    subprocess.run(["pip", "install", package])

def check_package(package):
    try:
        importlib.import_module(package)
        return True
    except ImportError:
        return False

packages_to_install = ["discord", "datetime", "requests", "asyncio", "watchdog"]
missing_packages = [package for package in packages_to_install if not check_package(package)]

if missing_packages:
    print(f"Folgende Pakete fehlen: {missing_packages}")
    print("Installation wird gestartet...")
    for package in missing_packages:
        install_package(package)
    print("Installation abgeschlossen!")
else:
    print("\n Alle benötigten Pakete sind bereits installiert.\n Starte Bot...\n")

from watchdog.observers import Observer
from watchdog.events import FileSystemEventHandler


class ConfigFileHandler(FileSystemEventHandler):
    def on_modified(self, event):
        if event.src_path.endswith('config.ini'):
            os.execv(sys.executable, ['python'] + sys.argv)

if __name__ == "__main__":
    event_handler = ConfigFileHandler()
    observer = Observer()
    observer.schedule(event_handler, path='.', recursive=False)
    observer.start()

    while True:
        print(" Konfiguration wird geladen...\n")
        
        if not os.path.exists("config.ini"):
            config = configparser.ConfigParser()
            config["DEFAULT"] = {
                "DC_TOKEN": "TOKEN",
                "SERVER_ID": "99",
                "CHANNEL_ID": "99"
            }
            config["VISUALS"] = {
                "SEND_MESSAGE": "1",
                "USE_EMBEDDED_MESSAGE": "1",
            }
            config["EMBEDDED_OPTIONS"] = {
                "SHOW_IMG": "1",
                "MESSAGE_IMG": "https://scumsaecke.de/src/std_msg_img.png",
                "SHOW_THUMB": "1",
                "MESSAGE_THUMB": "https://scumsaecke.de/src/std_msg_thumb.png",
                "SHOW_PLAYERS": "1",
                "SHOW_STATUS": "1",
                "SHOW_IP": "1",
                "SHOW_TIME": "1",
                "SHOW_RANK": "1",
                "SHOW_VERSION": "1",
            }
            with open("config.ini", "w") as config_file:
                config.write(config_file)
                
            print("\n ===================\n START UNTERBROCHEN!\n ===================\n Die Konfigurationsdatei wurde nicht gefunden!\n Eine neue config.ini wurde gerade erstellt.\n\n Trage die Werte in die Datei ein und starte den Bot neu.\n")
            input("\n Drücke Eingabe zum beenden...")
            sys.exit()
        
        import discord
        import requests
        import asyncio
        import time
        from datetime import datetime
        
        config = configparser.ConfigParser()
        config.read("config.ini")
        
        DC_TOKEN = config['DEFAULT']['DC_TOKEN']
        SERVER_ID = config.getint('DEFAULT', 'SERVER_ID')
        SERVER_ID_CHECK = config.get('DEFAULT', 'SERVER_ID')
        CHANNEL_ID = config.getint('DEFAULT', 'CHANNEL_ID')
        CHANNEL_ID_CHECK = config.get('DEFAULT', 'CHANNEL_ID')
        SEND_MESSAGE = config.getboolean('VISUALS', 'SEND_MESSAGE', fallback=True)
        SEND_MESSAGE_CHECK = config.get('VISUALS', 'SEND_MESSAGE')
        USE_EMBED = config.getboolean('VISUALS', 'USE_EMBEDDED_MESSAGE', fallback=True)
        MESSAGE_IMG = config.get('EMBEDDED_OPTIONS', 'MESSAGE_IMG')
        MESSAGE_THUMB = config.get('EMBEDDED_OPTIONS', 'MESSAGE_THUMB')
        SHOW_IMG = config.getboolean('EMBEDDED_OPTIONS', 'SHOW_IMG', fallback=True)
        SHOW_THUMB = config.getboolean('EMBEDDED_OPTIONS', 'SHOW_THUMB', fallback=True)
        SHOW_PLAYERS = config.getboolean('EMBEDDED_OPTIONS', 'SHOW_PLAYERS', fallback=True)
        SHOW_STATUS = config.getboolean('EMBEDDED_OPTIONS', 'SHOW_STATUS', fallback=True)
        SHOW_IP = config.getboolean('EMBEDDED_OPTIONS', 'SHOW_IP', fallback=True)
        SHOW_TIME = config.getboolean('EMBEDDED_OPTIONS', 'SHOW_TIME', fallback=True)
        SHOW_RANK = config.getboolean('EMBEDDED_OPTIONS', 'SHOW_RANK', fallback=True)
        SHOW_VERSION = config.getboolean('EMBEDDED_OPTIONS', 'SHOW_VERSION', fallback=True)
                
        hasConfigError = False
        
        if DC_TOKEN == "TOKEN":
            print(" Fehler: DC_TOKEN nicht eingetragen!")
            hasConfigError = True
            input(" Drücke Enter, um fortzufahren...")
        if SERVER_ID_CHECK == "99":
            print(" Fehler: SERVER_ID nicht eingetragen!")
            hasConfigError = True
            input(" Drücke Enter, um fortzufahren...")
        if CHANNEL_ID_CHECK == "99" and SEND_MESSAGE_CHECK == "1":
            print(" Fehler: CHANNEL_ID nicht eingetragen obwohl Channel-Post aktiviert ist!\n Deaktiviere die Channel-Nachricht oder Trage eine gültige ID ein.")
            hasConfigError = True
            input(" Drücke Enter, um fortzufahren...")
        
        if hasConfigError:
            print (" ACHTUNG: Konfigurationsproblem festgestellt!")
            input(" Drücke Enter zum beenden...")
            sys.exit()
        
        intents = discord.Intents.all()
        client = discord.Client(intents=intents)
        
        async def update_nickname(online_players, max_players):
            """Aktualisiert den Nickname des Bots mit den Spielerzahlen"""
            try:
                for guild in client.guilds:
                    try:
                        await guild.me.edit(nick=f"{online_players}/{max_players} Spieler online")
                    except discord.Forbidden:
                        print(f"Keine Berechtigung, Nickname in {guild.name} zu ändern")
                    except Exception as e:
                        print(f"Fehler beim Nickname-Update in {guild.name}: {e}")
            except Exception as e:
                print(f"Allgemeiner Fehler beim Nickname-Update: {e}")
        
        async def update_server_status():
            await client.wait_until_ready()
            channel = client.get_channel(CHANNEL_ID)
        
            if os.path.isfile("messageid.txt"):
                with open("messageid.txt", "r") as f:
                    message_id = f.read()
                    if message_id.strip() == "":
                        message_id = None
                    else:
                        message_id = int(message_id)
            else:
                message_id = None
            
            first_loop = True
            message = None
            
            while not client.is_closed():
                try:
                    response = requests.get(f'http://api.battlemetrics.com/servers/{SERVER_ID}')
                    data = response.json()['data']
                    server_ip = data['attributes'].get('ip', 'Unbekannt')
                    server_port = data['attributes'].get('port', 'Unbekannt')
                    server_name = data['attributes'].get('name', 'Unbekannt')
                    server_status = data['attributes'].get('status', 'dead')
                    server_rank = data['attributes'].get('rank', 'Unbekannt')
                    server_version = data['attributes']['details'].get('version', 'Unbekannt')
                    server_time = data['attributes']['details'].get('time', 'Unbekannt')
                    online_players = data['attributes'].get('players', 'Unbekannt')
                    max_players = data['attributes'].get('maxPlayers', 'Unbekannt')
                    
                    query_status = data['attributes'].get('queryStatus', 'Unbekannt')
                    timestamp = datetime.now().strftime("(letztes Update: %H:%M)")

                    # Aktualisiere den Nickname mit den Spielerzahlen
                    await update_nickname(online_players, max_players)
                    
                    if USE_EMBED:
                        if query_status == 'valid':
                            server_name = data['attributes']['name']
                            embed = discord.Embed(title=server_name, color=discord.Color.green())
                            if SHOW_PLAYERS:embed = discord.Embed(title=f"{server_name}", description=f"Zur Zeit sind {online_players}/{max_players} Spieler online", color=0x00ff00)
                            if SHOW_STATUS:embed.add_field(name="Serverstatus", value=f"{server_status} ✅", inline=False)
                            if SHOW_IP:embed.add_field(name="IP", value=f"{server_ip}:{server_port}", inline=False)
                            if SHOW_TIME:embed.add_field(name="Inselzeit", value=f"{server_time} Uhr", inline=False)
                            if SHOW_RANK:embed.add_field(name="Rang", value=f"{server_rank}", inline=False)
                            if SHOW_VERSION:embed.add_field(name="Version", value=f"{server_version}", inline=False)
                            if SHOW_IMG: embed.set_image(url=MESSAGE_IMG)
                            if SHOW_THUMB: embed.set_thumbnail(url=MESSAGE_THUMB)
                            embed.set_footer(text=f"{timestamp} - mit Unterstützung von Scumworld.de")
                            
                            
                        else:
                            embed = discord.Embed(title=server_name, description="```diff\n-Keine Antwort! Server offline?```", color=discord.Color.red())
                
                        if SEND_MESSAGE:
                            if message_id is not None:
                                try:
                                    message = await channel.fetch_message(message_id)
                                except discord.NotFound:
                                    message = None
            
                            if first_loop:
                                print(" Konfiguration:\n")
                                time.sleep(0.1)
                            if first_loop:
                                print(" => Posten der Serverdaten im Info-Kanal ist aktiviert!\n Spezifische Konfiguration:\n")
                                time.sleep(0.1)
                            if first_loop and USE_EMBED == 0:
                                print(" - Embedded Nachricht deaktiviert!\n   Dadurch sind keine weiteren Optionen relevant!")
                                time.sleep(0.1)
                            if first_loop and USE_EMBED:
                                print(" Als eingebettete Nachricht anzeigen: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_IMG == 1 and USE_EMBED == 1:
                                print(" - Serverbild: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_IMG == 0 and USE_EMBED == 1:
                                print(" - Serverbild: NEIN")
                                time.sleep(0.1)
                            if first_loop and SHOW_THUMB == 1 and USE_EMBED == 1:
                                print(" - Thumbnail: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_THUMB == 0 and USE_EMBED == 1:
                                print(" - Thumbnail: NEIN")
                                time.sleep(0.1)
                            if first_loop and SHOW_PLAYERS == 1 and USE_EMBED == 1:
                                print(" - Spielerzahl: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_PLAYERS == 0 and USE_EMBED == 1:
                                print(" - Spielerzahl: NEIN")
                                time.sleep(0.1)
                            if first_loop and SHOW_STATUS == 1 and USE_EMBED == 1:
                                print(" - Serverstatus: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_STATUS == 0 and USE_EMBED == 1:
                                print(" - Serverstatus: NEIN")
                                time.sleep(0.1)
                            if first_loop and SHOW_IP == 1 and USE_EMBED == 1:
                                print(" - IP anzeigen: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_IP == 0 and USE_EMBED == 1:
                                print(" - IP anzeigen: NEIN")
                                time.sleep(0.1)
                            if first_loop and SHOW_TIME == 1 and USE_EMBED == 1:
                                print(" - Inselzeit: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_TIME == 0 and USE_EMBED == 1:
                                print(" - Inselzeit: NEIN")
                                time.sleep(0.1)
                            if first_loop and SHOW_RANK == 1 and USE_EMBED == 1:
                                print(" - Rang: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_RANK == 0 and USE_EMBED == 1:
                                print(" - Rang: NEIN")
                                time.sleep(0.1)
                            if first_loop and SHOW_VERSION == 1 and USE_EMBED == 1:
                                print(" - Version: JA")
                                time.sleep(0.1)
                            if first_loop and SHOW_VERSION == 0 and USE_EMBED == 1:
                                print(" - Version: NEIN")
                                time.sleep(0.1)

                            first_loop = False
                
                            if message is None:
                                message = await channel.send(embed=embed)
                                message_id = message.id
                                with open("messageid.txt", "w") as f:
                                    f.write(str(message_id))
                            else:
                                await message.edit(embed=embed)
                        else:
                        
                            if first_loop:
                                print(" Konfiguration:")
                                time.sleep(0.1)
                                
                            if first_loop:
                                print(" - Posten der Serverdaten ist deaktiviert!\n   => Weitere Einstellungen sind egalisiert!")
                            first_loop = False
                            
                        if query_status == 'valid':
                            activity = discord.Activity(type=discord.ActivityType.watching, name=f"auf die Uhr: {server_time}")
                        else:
                            activity = discord.Activity(type=discord.ActivityType.watching, name=f"keine Daten...")
                        await client.change_presence(activity=activity)
                        
                    else:
                        if query_status == 'valid':
                            activity = discord.Game(name=f"{online_players}/{max_players} online")
                            message_content = f'\n***{server_name}***\n\nZur Zeit sind **{online_players}/{max_players}** Spieler online\n\n```\nServerstatus: {server_status} ✅\n\nIP: {server_ip}:{server_port}\nInselzeit: {server_time} Uhr\n\nRang: {server_rank}\nVersion: {server_version}\n```\n{timestamp}\n - *mit freundlicher Unterstützung von Scumworld.de*'
            
                        else:
                            activity = discord.Game(name=f"keine Daten...")
                            message_content = f"\n***{server_name}***\n```diff\n-Der Server scheint offline zu sein!\n\n```\nNächste Aktualisierung in 1 Minute.\n{timestamp}"
            
                        if SEND_MESSAGE:
                            if message_id is not None:
                                try:
                                    message = await channel.fetch_message(message_id)
                                except discord.NotFound:
                                    message = None
                            
                            if first_loop:
                                print(" Konfiguration:")
                                time.sleep(0.1)
            
                            if first_loop:
                                print(" - Posten der Serverdaten im Info-Kanal ist aktiviert!")
                                time.sleep(0.1)
        
                            if first_loop:
                                print(" - Embedded Message deaktiviert!\n   => Weitere Einstellungen sind damit vorerst egalisiert!")
                                time.sleep(0.1)
                            first_loop = False
            
                            if message is None:
                                message = await channel.send(message_content)
                                message_id = message.id
                                with open("messageid.txt", "w") as f:
                                    f.write(str(message_id))
                            else:
                                await message.edit(content=message_content)
        
                        if query_status == 'valid':
                            activity = discord.Activity(type=discord.ActivityType.watching, name=f"auf die Uhr: {server_time}")
                        else:
                            activity = discord.Activity(type=discord.ActivityType.watching, name=f"keine Daten...")
                        await client.change_presence(activity=activity)
            
                except requests.exceptions.RequestException as e:
                    print(f" BM-API-Fehler: {e}")
                    await asyncio.sleep(60)
                    continue
            
                except discord.DiscordException as e:
                    print(f" Discord-API-Fehler: {e}")
                    await asyncio.sleep(60)
                    continue
            
                await asyncio.sleep(60)
        
        @client.event
        async def on_ready():
            print(f'\n |---------------------------\n |Eingeloggt als {client.user.name}!\n |\n |Der Bot ist bereit!\n |---------------------------\n')
            
            # Initiales Nickname-Update beim Start
            try:
                response = requests.get(f'http://api.battlemetrics.com/servers/{SERVER_ID}')
                data = response.json()['data']
                online_players = data['attributes'].get('players', '?')
                max_players = data['attributes'].get('maxPlayers', '?')
                await update_nickname(online_players, max_players)
            except Exception as e:
                print(f"Fehler beim initialen Nickname-Update: {e}")
            
            client.loop.create_task(update_server_status())
      
        
        client.run(DC_TOKEN)